<?php
/**
 * Plugin Name:       EstudioWeb Image Optimizer
 * Description:       Optimiza y gestiona la conversión de imágenes a formato WebP con funciones automáticas.
 * Version:           1.3.0
 * Author:            Iván Studio
 * Author URI:        https://ivanstudioweb.com/
 * License:           GPL-2.0-or-later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       estudioweb-optimizer
 */

if (!defined('ABSPATH')) {
    exit; // Salir si se accede directamente.
}

// Definir constantes del plugin
define('EWO_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('EWO_PLUGIN_URL', plugin_dir_url(__FILE__));

// Incluir archivos necesarios
require_once EWO_PLUGIN_DIR . 'includes/ajax-functions.php';
require_once EWO_PLUGIN_DIR . 'includes/cron-functions.php';

// Hooks de activación y desactivación para las tareas programadas
register_activation_hook(__FILE__, 'ewo_activate_plugin');
register_deactivation_hook(__FILE__, 'ewo_deactivate_plugin');

/**
 * Acciones al activar el plugin: programar las tareas.
 */
function ewo_activate_plugin() {
    // Programar la limpieza diaria de originales si no está ya programada.
    if (!wp_next_scheduled('ewo_daily_cleanup_hook')) {
        wp_schedule_event(time(), 'daily', 'ewo_daily_cleanup_hook');
    }
    // Programar el escaneo semanal si no está ya programado.
    if (!wp_next_scheduled('ewo_weekly_scan_hook')) {
        wp_schedule_event(time(), 'weekly', 'ewo_weekly_scan_hook');
    }
}

/**
 * Acciones al desactivar el plugin: limpiar las tareas programadas.
 */
function ewo_deactivate_plugin() {
    wp_clear_scheduled_hook('ewo_daily_cleanup_hook');
    wp_clear_scheduled_hook('ewo_weekly_scan_hook');
}

/**
 * Agrega la página del plugin al menú de administración de WordPress.
 */
function ewo_add_admin_menu() {
    add_media_page(
        'Optimizador de Imágenes',
        'Optimizador WebP',
        'manage_options',
        'estudioweb-optimizer',
        'ewo_admin_page_html'
    );
}
add_action('admin_menu', 'ewo_add_admin_menu');

/**
 * Muestra el contenido HTML de la página de administración.
 */
function ewo_admin_page_html() {
    require_once EWO_PLUGIN_DIR . 'includes/admin-page.php';
}

/**
 * Carga los scripts y estilos necesarios para la página de administración del plugin.
 */
function ewo_enqueue_admin_assets($hook) {
    if ('media_page_estudioweb-optimizer' !== $hook) {
        return;
    }

    wp_enqueue_style('ewo-admin-style', EWO_PLUGIN_URL . 'assets/admin.css', [], '1.3.0');
    wp_enqueue_script('ewo-admin-script', EWO_PLUGIN_URL . 'assets/admin.js', ['jquery'], '1.3.0', true);

    wp_localize_script('ewo-admin-script', 'ewo_ajax', [
        'ajax_url' => admin_url('admin-ajax.php'),
        'nonce'    => wp_create_nonce('ewo_ajax_nonce'),
        'confirm_revert' => __('¿Estás seguro de que quieres restaurar TODAS las imágenes? Esto eliminará las versiones WebP y restaurará las URLs originales en tu base de datos. Esta acción no se puede deshacer.', 'estudioweb-optimizer'),
    ]);
}
add_action('admin_enqueue_scripts', 'ewo_enqueue_admin_assets');
